#include <stdio.h>

#include "libfma.h"
#include "lf_internal.h"
#include "lf_alert.h"

/*
 * Use the automatically generated routines and data in lf_alert_internal.h
 * to build an array of alert stuff - name, print routine, flags, etc.
 */

#include "lf_alert_internal.h"
struct alert_def **lf_alert_def_array;
  
/*
 * Build an array indexed by alert type that gives all info for
 * an alert
 */
int
lf_init_alert()
{
  struct alert_def *adp;

  /* allocate array of pointers */
  LF_CALLOC(lf_alert_def_array, struct alert_def *, LF_ALERT_MAX_ALERT);

  /* fill in the possibly sparse array */
  adp = alert_defs;
  while (adp->ad_type != -1) {
    lf_alert_def_array[adp->ad_type] = adp;
    ++adp;
  }

  return 0;

 except:
  return -1;
}

/*
 * Return flags for a given alert
 */
int
lf_alert_flags(
  struct lf_alert *ap)
{
  return lf_alert_def_array[ap->alert_type]->flags;
}

/*
 * Put string for an alert into a buffer
 */
int
lf_alert_string(
  char *buf,
  struct lf_alert *ap)
{
  return lf_alert_def_array[ap->alert_type]->print_rtn(buf, ap);
}

/*
 * Return alert name
 */
char *
lf_alert_name(
  struct lf_alert *ap)
{
  return lf_alert_def_array[ap->alert_type]->name;
}

/*
 * Convert all appropriate fields in an alert struct to network order
 */
void
lf_alert_hton(
  struct lf_alert *ap)
{
  lf_alert_def_array[ap->alert_type]->byteswap_rtn(ap);
}

/*
 * Convert all appropriate fields in an alert struct to host order
 */
void
lf_alert_ntoh(
  struct lf_alert *ap)
{
  lf_alert_def_array[ntohl(ap->alert_type)]->byteswap_rtn(ap);
}
